<?php
session_start();
// ⚠️ সুরক্ষার জন্য: বাস্তব ক্ষেত্রে, পাসওয়ার্ড কখনই এভাবে প্লেন টেক্সট ('123456') হিসেবে সংরক্ষণ করা উচিত নয়।
// পরিবর্তে, অবশ্যই password_hash() ফাংশন ব্যবহার করে পাসওয়ার্ড হ্যাশ (Hash) করা উচিত।

include 'database.php';

if (isset($_SESSION['username'])) {
    header('Location: dashboard.php');
    exit;
}

## অ্যাডমিন টেবিল তৈরি
$createAdminTableSQL = "
    CREATE TABLE IF NOT EXISTS admin (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(255) NOT NULL UNIQUE,
        password VARCHAR(255) NOT NULL
    )
";
$conn->query($createAdminTableSQL);

// -------------------------------------------------------------
## ✨ ডিফল্ট অ্যাডমিন তৈরির লজিক ✨
// -------------------------------------------------------------

$defaultUsername = 'admin';
$defaultPassword = '123456'; // ⚠️ খুবই অনিরাপদ, এটি password_hash() দিয়ে প্রতিস্থাপন করুন

// 1. admin ইউজারটি আছে কিনা চেক করা হচ্ছে
$checkAdminSQL = "SELECT id FROM admin WHERE username = ?";
$stmt = $conn->prepare($checkAdminSQL);
$stmt->bind_param("s", $defaultUsername);
$stmt->execute();
$result = $stmt->get_result();

// 2. যদি admin না থাকে, তবে ইনসার্ট করা হচ্ছে
if ($result->num_rows === 0) {
    // ⚠️ এই লাইনটি বাস্তব ক্ষেত্রে ব্যবহার করুন: $hashedPassword = password_hash($defaultPassword, PASSWORD_DEFAULT);
    
    $insertAdminSQL = "INSERT INTO admin (username, password) VALUES (?, ?)";
    $stmtInsert = $conn->prepare($insertAdminSQL);
    // ⚠️ প্লেন টেক্সট পাসওয়ার্ড ব্যবহার করা হচ্ছে।
    $stmtInsert->bind_param("ss", $defaultUsername, $defaultPassword); 
    
    $stmtInsert->execute();
    $stmtInsert->close();
}

$stmt->close();
// -------------------------------------------------------------

function validateAdmin($username, $password, $conn) {
    // ⚠️ পাসওয়ার্ড হ্যাশ ব্যবহার করলে এই ফাংশনটি পরিবর্তন করতে হবে (password_verify ব্যবহার করতে হবে)।
    $query = "SELECT id FROM admin WHERE username = '$username' AND password = '$password'";
    $result = $conn->query($query);

    return $result->num_rows > 0;
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (isset($_GET['password'])) {
        $key = trim($_POST['key'] ?? '');
        if ($key === 'your_key') {
            // Replace 'your_key' with your actual setup key
            $stmt = $conn->prepare("SELECT id FROM admin WHERE username = ?");
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                // ⚠️ এখানেও পাসওয়ার্ড হ্যাশ করে সংরক্ষণ করা উচিত
                $stmt = $conn->prepare("UPDATE admin SET password = ? WHERE username = ?");
                $stmt->bind_param("ss", $password, $username);
                if ($stmt->execute()) {
                    $success = "ADMIN PASSWORD UPDATED SUCCESSFULLY.";
                    $redirect = 'dashboard.php'; // redirect = '../adminx' এর পরিবর্তে dashboard.php দিলাম
                } else {
                    $error = "ERROR UPDATING ADMIN PASSWORD.";
                }
            } else {
                 // ⚠️ এখানেও পাসওয়ার্ড হ্যাশ করে সংরক্ষণ করা উচিত
                $stmt = $conn->prepare("INSERT INTO admin (username, password) VALUES (?, ?)");
                $stmt->bind_param("ss", $username, $password);
                if ($stmt->execute()) {
                    $success = "ADMIN SETUP SUCCESSFUL.";
                    $redirect = 'dashboard.php'; // redirect = '../adminx' এর পরিবর্তে dashboard.php দিলাম
                } else {
                    $error = "ERROR SETTING UP ADMIN.";
                }
            }
            $stmt->close();

        } else {
            $error = "Invalid setup key.";
        }
    } else {
        // Admin login logic
        if (validateAdmin($username, $password, $conn)) {
            $_SESSION['username'] = $username;

            $createUsersTableSQL = "
               CREATE TABLE IF NOT EXISTS users (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    username VARCHAR(255) NOT NULL UNIQUE,
                    apiKey VARCHAR(255) NOT NULL UNIQUE,
                    status VARCHAR(255) NOT NULL,
                    createDate DATETIME DEFAULT NOW(),
                    expiryDate DATETIME DEFAULT NULL,
                    balance INT DEFAULT 0,
                    `limit` INT DEFAULT 0,
                    used INT DEFAULT 0
                );
            ";
            $conn->query($createUsersTableSQL);

            $success = "ACCESS GRANTED! LOGIN SUCCESSFUL.";
            $redirect = 'dashboard.php';
        } else {
            $error = "INVALID USERNAME OR PASSWORD. PLEASE TRY AGAIN!";
        }
    }
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($_GET['password']) ? 'Admin Setup' : 'Admin Login'; ?> - KEY MANAGEMENT</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
    <link href="dialog/dialog.css" rel="stylesheet">
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <style>
        body {
            background-color: #f8f9fa;
            color: #343a40;
            font-family: 'Roboto', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 90vh;
            margin: 0;
        }
        .form {
            display: flex;
            flex-direction: column;
            gap: 10px;
            padding-left: 2em;
            padding-right: 2em;
            padding-bottom: 0.4em;
            background-color: #171717;
            border-radius: 25px;
            transition: 0.4s ease-in-out;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        }

        .card {
            background-image: linear-gradient(163deg, #00ff75 0%, #3700ff 100%);
            border-radius: 22px;
            transition: all 0.3s;
        }

        .card2 {
            border-radius: 0;
            transition: all 0.2s;
        }

        .card2:hover {
            transform: scale(0.98);
            border-radius: 20px;
        }

        .card:hover {
            box-shadow: 0px 0px 30px 1px rgba(0, 255, 117, 0.3);
        }

        #heading {
            text-align: center;
            margin: 2em;
            color: rgb(255, 255, 255);
            font-size: 1.2em;
        }

        .field {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5em;
            border-radius: 25px;
            padding: 0.6em;
            border: none;
            outline: none;
            color: white;
            background-color: #171717;
            box-shadow: inset 2px 5px 10px rgb(5, 5, 5);
        }

        .input-icon {
            height: 1.3em;
            width: 1.3em;
            fill: white;
        }

        .input-field {
            background: none;
            border: none;
            outline: none;
            width: 100%;
            color: #d3d3d3;
        }

        .form .btn {
            display: flex;
            justify-content: center;
            flex-direction: row;
            margin-top: 2.5em;
        }

        .button1 {
            padding: 0.5em;
            padding-left: 1.1em;
            padding-right: 1.1em;
            border-radius: 5px;
            margin-right: 0.5em;
            border: none;
            outline: none;
            transition: 0.4s ease-in-out;
            background-color: #252525;
            color: white;
        }

        .button1:hover {
            background-color: black;
            color: white;
        }

        .button2 {
            padding: 0.5em;
            padding-left: 2.3em;
            padding-right: 2.3em;
            border-radius: 5px;
            border: none;
            outline: none;
            transition: 0.4s ease-in-out;
            background-color: #252525;
            color: white;
        }

        .button2:hover {
            background-color: black;
            color: white;
        }

        .button3 {
            margin-bottom: 3em;
            padding: 0.5em;
            border-radius: 5px;
            border: none;
            outline: none;
            transition: 0.4s ease-in-out;
            background-color: #252525;
            color: white;
        }

        .button3:hover {
            background-color: red;
            color: white;
        }
        .alert {
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
        }
        .alert-danger {
            background-color: red;
            color: white;
        }
    </style>
</head>


<body>
    <div class="card">
        <div class="card2">
            <form class="form" action="" method="POST">
                <p id="heading">
                    <?php echo isset($_GET['password']) ? 'ADD NEW ADMIN' : 'ADMIN LOGIN'; ?>
                </p>
                <div class="field">
                    <svg
                        viewBox="0 0 16 16"
                        fill="currentColor"
                        height="16"
                        width="16"
                        xmlns="http://www.w3.org/2000/svg"
                        class="input-icon"
                        >
                        <path
                            d="M13.106 7.222c0-2.967-2.249-5.032-5.482-5.032-3.35 0-5.646 2.318-5.646 5.702 0 3.493 2.235 5.708 5.762 5.708.862 0 1.689-.123 2.304-.335v-.862c-.43.199-1.354.328-2.29.328-2.926 0-4.813-1.88-4.813-4.798 0-2.844 1.921-4.881 4.594-4.881 2.735 0 4.608 1.688 4.608 4.156 0 1.682-.554 2.769-1.416 2.769-.492 0-.772-.28-.772-.76V5.206H8.923v.834h-.11c-.266-.595-.881-.964-1.6-.964-1.4 0-2.378 1.162-2.378 2.823 0 1.737.957 2.906 2.379 2.906.8 0 1.415-.39 1.709-1.087h.11c.081.67.703 1.148 1.503 1.148 1.572 0 2.57-1.415 2.57-3.643zm-7.177.704c0-1.197.54-1.907 1.456-1.907.93 0 1.524.738 1.524 1.907S8.308 9.84 7.371 9.84c-.895 0-1.442-.725-1.442-1.914z"
                            ></path>
                    </svg>
                    <input type="text" name="username" class="input-field" placeholder="Username" autocomplete="off" />
                </div>
                <div class="field">
                    <svg
                        viewBox="0 0 16 16"
                        fill="currentColor"
                        height="16"
                        width="16"
                        xmlns="http://www.w3.org/2000/svg"
                        class="input-icon"
                        >
                        <path
                            d="M8 1a2 2 0 0 1 2 2v4H6V3a2 2 0 0 1 2-2zm3 6V3a3 3 0 0 0-6 0v4a2 2 0 0 0-2 2v5a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2z"
                            ></path>
                    </svg>
                    <input type="password" name="password" class="input-field" placeholder="Password" />
                </div>

                <?php if (isset($_GET['password'])): ?>
                <div class="field">
                    <svg
                        viewBox="0 0 16 16"
                        fill="currentColor"
                        height="16"
                        width="16"
                        xmlns="http://www.w3.org/2000/svg"
                        class="input-icon"
                        >
                        <path
                            d="M11.742 4.257a4.4 4.4 0 0 1 0 6.243l-1.17 1.17a4.4 4.4 0 0 1-6.243 0L3.343 7.762a4.4 4.4 0 0 1 0-6.243 4.4 4.4 0 0 1 6.243 0L8 3.129l2.499-2.499a4.4 4.4 0 0 1 6.243 0zM8 5.829l-1.418 1.417a2 2 0 0 0 0 2.828 2 2 0 0 0 2.828 0l1.418-1.417a2 2 0 0 0 0-2.828 2 2 0 0 0-2.828 0z"
                            ></path>
                    </svg>
                    <input type="text" name="key" class="input-field" placeholder="ADMIN KEY" required>
                </div>
                <?php endif; ?>

                <div class="btn">
                    <button class="button1">
                        <?php echo isset($_GET['password']) ? 'ADD ADMIN' : '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Login&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; ?>
                    </button>
                </div>
                <?php
                if (isset($error)) {
                    echo "<script>
                            swal({
                                title: 'Error!!',
                                text: '$error',
                                icon: 'error',
                                dangerMode: true
                            });
                          </script>";
                }
                if (isset($success)) {
                    echo "<script>
                    swal({
                        title: 'Success!!',
                        text: '" . $success . "',
                        icon: 'success',
                        buttons: {
                            confirm: 'OK'
                        }
                    })
                    .then((willConfirm) => {
                        if (willConfirm) {
                            window.location.href = '" . $redirect . "';
                        }
                    });
                     </script>";
                    echo "<script>
                          setTimeout(function() {
                             window.location.href = '" . $redirect . "';
                          }, 2500);
                     </script>";
                }
                ?>
            </form>
        </div>
    </div>
</body>
</html>
