<?php
session_start();
include 'database.php';
header('Content-Type: application/json');

if (!isset($_SESSION['username'])) {
    http_response_code(401);
    echo json_encode(["success" => false, "message" => "UNAUTHORIZED ACCESS."]);
    exit;
}

ini_set('display_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    response(false, "INVALID REQUEST METHOD. POST REQUIRED.");
}

$data = json_decode(file_get_contents("php://input"), true);
if (!$data || !is_array($data)) {
    response(false, "Invalid JSON data received. Ensure Content-Type is 'application/json'.");
}

$requiredFields = ['apiKey', 'username', 'status', 'expDate', 'limit'];
foreach ($requiredFields as $field) {
    if (empty($data[$field])) {
        response(false, "MISSING REQUIRED FIELD: $field");
    }
}

$apiKey = trim($data['apiKey']);
$username = trim($data['username']);
$status = trim($data['status']);
$expDate = trim($data['expDate']);
$limitInput = $data['limit'];

if (strcasecmp(strval($limitInput), 'UNLIMITED') === 0) {
    $limit = 99999999;
    $newBalance = 99999999;
} elseif (is_numeric($limitInput) && $limitInput >= 0 && $limitInput < 99999999) {
    $limit = intval($limitInput);
    $newBalance = intval($limitInput);
} else {
    response(false, "INVALID DATA: 'limit' MUST BE NUMERIC AND NON-NEGATIVE OR 'UNLIMITED'.");
}

if (!DateTime::createFromFormat('Y-m-d H:i:s', $expDate)) {
    response(false, "INVALID 'expDate' FORMAT. USE 'Y-m-d H:i:s'.");
}

$updateSql = "UPDATE users SET username = ?, apiKey = ?, status = ?, expiryDate = ?, `limit` = ?, balance = ? WHERE apiKey = ?";
$updateStmt = $conn->prepare($updateSql);
if (!$updateStmt) {
    error_log("SQL Prepare Error: " . $conn->error);
    response(false, "DATABASE ERROR: UNABLE TO PREPAREARE UPDATE STATEMENT.");
}

$updateStmt->bind_param("ssssiis", $username, $apiKey, $status, $expDate, $limit, $newBalance, $apiKey);
if ($updateStmt->execute()) {
    $affectedRows = $updateStmt->affected_rows;
    if ($affectedRows > 0) {
        response(true, "USER DETAILS UPDATED SUCCESSFULLY.", ["affectedRows" => $affectedRows]);
    } else {
        response(false, "NO CHANGES MADE. DETAILS ARE ALREADY UP-TO-DATE OR THE USER DOES NOT EXIST.");
    }
} else {
    error_log("SQL Execute Error: " . $updateStmt->error);
    response(false, "FAILED TO UPDATE USER DETAILS.");
}

$updateStmt->close();
$conn->close();

function response($success, $message, $data = []) {
    http_response_code($success ? 200 : 400);
    echo json_encode(array_merge(["success" => $success, "message" => $message], $data), JSON_PRETTY_PRINT);
    exit;
}
?>